// Custom Trader Lama Name
EntityEvents.spawned('minecraft:trader_llama', event =>{
    customName(event.entity, 'Mr. Llama', 10)
})

EntityEvents.spawned('minecraft:item', event => {
    const {entity} = event
    if(entity.displayName.toString().contains('guardian_fragment')){
        entity.glowing = true
    }

})
// Custom Frog Name
EntityEvents.spawned('minecraft:frog', event =>{
    customName(event.entity, 'Troxarus', 5)
})

EntityEvents.spawned(['adventurez:red_fungus', 'adventurez:brown_fungus'], event =>{
    customName(event.entity, 'Matrixis', 10)
})

EntityEvents.spawned('minecraft:wandering_trader', event =>{
    customName(event.entity, 'Sataana', 5)
})

EntityEvents.spawned('adventurez:enderwarthog', event => {
    const {level, entity} = event
    if (level.dimension == 'minecraft:the_nether'){
        entity.setMaxHealth(30)
        entity.setHealth(30)
    }
})

EntityEvents.spawned('adventurez:enderwarthog', event =>{
    const {entity, level} = event
    const {x, z} = entity
    if ((x >= 128 || x <= -128) &&
        (z >= 128 || z <= -128) && level.dimension != 'minecraft:the_end') return
    entity.setMaxHealth(30)
    entity.setHealth(30)
})

EntityEvents.spawned('adventurez:piglin_beast', event =>{
    event.server.tell(`A Piglin beast has been summoned at x: ${event.entity.x} y: ${event.entity.y} z: ${event.entity.z}.`)
})

EntityEvents.spawned('adventurez:void_shade', event => {
    const {entity} = event
    const attributes = [
        ['generic.attack_damage', 10],
        ['generic.attack_knockback', 5],
        ['generic.armor', 10],
        ['generic.armor_toughness', 20],
        ['generic.follow_range', 2048],
        ['generic.knockback_resistance', 1.0],
        ['generic.movement_speed', 0.7]]

    attributes.forEach(attributeArr => {
        let attribute = attributeArr[0]
        let value = attributeArr[1]
        entity.setAttributeBaseValue(attribute, value) 
    })
})
// Magic Goat Horn
EntityEvents.spawned('minecraft:item', event => {
    // random goat horn chance
    if (event.entity.item == 'minecraft:goat_horn'){
        let nbt = event.entity.fullNBT
        if (nbt.Item.tag?.horncheck == 1) return
        let random = getRandomInt(1, 10)
        if (random <= 1) event.entity.setItem('lote:goat_horn')
        if (random > 1){
            nbt.Item.tag['horncheck'] = 1
            event.entity.fullNBT = nbt
        }
    }
    if (event.entity.item == 'endrem:magical_eye'){ 
        let nbt = event.entity.fullNBT
        if (nbt?.NoGravity == 1) event.server.scheduleInTicks(100, (_) => {
            nbt.NoGravity = 0
            event.entity.fullNBT = nbt
        })
    } 
})

// Disable Blaze Guardian regular spawning
EntityEvents.spawned('adventurez:blaze_guardian', event => {
    const {entity} = event
    let tags = entity.fullNBT?.Tags ?? 'none'
    if (!tags.toString().includes('Boss')) event.cancel()
})

// Piglin Beast Reinforcement
EntityEvents.hurt('minecraft:piglin', event => {
    const {x, y, z, level} = event.entity
    let player = event.source.getActual()
    if (!player) return
    if (!player.isPlayer()) return
    let chance = getRandomInt(1, 100)
    if (chance <= 5) {
        let entity = level.createEntity('adventurez:piglin_beast')
        entity.x = x
        entity.y = y
        entity.z = z
        entity.spawn()
    }
})

EntityEvents.hurt('adventurez:enderwarthog', event => {
    const {source} = event
    if (source == 'DamageSource (fall)' || source == 'DamageSource (lightningBolt)') event.cancel()
})

// Skeleton Undead Soul
EntityEvents.death(['minecraft:skeleton','minecraft:wither_skeleton'], event => {
    if (event.entity.block.biomeId == 'minecraft:soul_sand_valley'){
        let chance = getRandomInt(1, 100)
        if (chance < 10) {
            let itemEntity = event.entity.block.createEntity("item")
            itemEntity.item = 'endrem:undead_soul'
            itemEntity.item.count = 1
            itemEntity.y+=0.8
            itemEntity.x+=0.5
            itemEntity.z+=0.5
            itemEntity.spawn()
        }
    }
})
